@props([
    'name',
    'price',
    'features',
    'highlighted' => false,
    'ctaBtnText' => __('Get Started'),
    'ctaSmText' => '',
    'ctaAction' => '#',
    'wireClick' => null,
    'alpineClick' => null,
    'planId' => null,
    'bgColor' => theme('pricingPlan', 'bgColor'),
    'highlightBorderColor' => theme('pricingPlan', 'highlightBorderColor'),
    'highlightBadgeColor' => theme('pricingPlan', 'highlightBadgeColor'),
    'highlightBadgeTextColor' => theme('pricingPlan', 'highlightBadgeTextColor'),
    'highlightBadgeText' => __('Best Value'),
    'nameColor' => theme('pricingPlan', 'nameColor'),
    'priceColor' => theme('pricingPlan', 'priceColor'),
    'featureColor' => theme('pricingPlan', 'featureColor'),
    'ctaBtnBgColor' => theme('pricingPlan', 'ctaBtnBgColor'),
    'ctaBtnTextColor' => theme('pricingPlan', 'ctaBtnTextColor'),
    'ctaBtnHoverBgColor' => theme('pricingPlan', 'ctaBtnHoverBgColor'),
    'ctaSmTextColor' => theme('pricingPlan', 'ctaSmTextColor'),
    'showCtaBtn' => true,
    'spinnerColor' => theme('pricingPlan', 'spinnerColor'),
])

<div class="w-full xl:w-1/3 lg:w-1/3 p-4">
    <div class="h-full {{ $bgColor }} max-w-sm mx-auto rounded-lg shadow-md p-7 flex flex-col @if($highlighted) relative border-2 {{ $highlightBorderColor }} @endif">
        @if($highlighted)
            <div class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                <span class="{{ $highlightBadgeColor }} {{ $highlightBadgeTextColor }} text-xs font-semibold px-3 py-1 rounded-full">
                    {{ $highlightBadgeText }}
                </span>
            </div>
        @endif

        <div class="flex-none">
            <h3 class="text-xl font-semibold mb-4 {{ $nameColor }}">{{ $name }}</h3>
            <p class="text-3xl font-bold mb-6 {{ $priceColor }}">{!! $price !!}</p>
        </div>

        <div class="flex-grow">
            <ul class="mb-6 space-y-2">
                @foreach($features as $feature)
                    <li class="{{ $featureColor }}">{!! $feature !!}</li>
                @endforeach
            </ul>
        </div>

        <div class="flex-none">
            @if($showCtaBtn)
                <div x-data="{ loading: false }">
                    <button
                        @if($wireClick)
                            x-on:click="if(!loading) {
                                loading = true;
                                setTimeout(() => {
                                    $wire.{{ $wireClick }}(@if($planId)'{{ $planId }}'@endif)
                                }, 500);
                                setTimeout(() => { loading = false }, 1200);
                            }"
                        @endif
                        @if($alpineClick)
                            x-on:click="if(!loading) {
                                loading = true;
                                setTimeout(() => {
                                    {{ $alpineClick }}(@if($planId)'{{ $planId }}'@endif, $event)
                                }, 500);
                                setTimeout(() => { loading = false }, 1200);
                            }"
                        @endif
                        @if($ctaAction)
                            x-on:click="if(!loading) {
                                loading = true;
                                setTimeout(() => {
                                    window.location.href = '{{ $ctaAction }}';
                                }, 500);
                            }"
                        @endif
                        @if($planId) id="{{ $planId }}" @endif
                        class="relative w-full flex items-center justify-center {{ $ctaBtnBgColor }} {{ $ctaBtnTextColor }} px-4 py-2 rounded-md {{ $ctaBtnHoverBgColor }} transition duration-300 mb-2"
                        :disabled="loading"
                    >
                        <span class="pointer-events-none">{!! $ctaBtnText !!}</span>
                        <svg x-show="loading" class="pointer-events-none animate-spin h-5 w-5 {{ $spinnerColor }} ml-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                    </button>
                </div>
            @endif

            <p class="text-center text-sm font-bold mt-1 {{ $ctaSmTextColor }}">{!! $ctaSmText !!}</p>
        </div>
    </div>
</div>
