<?php

/*
|--------------------------------------------------------------------------
| Themes Configuration for Landing Page Components and the global app
|--------------------------------------------------------------------------
|
| This configuration file defines the default themes for the landing page
| components and the whole app. The standard themes provided are "light"
| and "dark." You may create custom themes as necessary. The "global" array
| addresses elements external to the landing page components. The active theme
| is specified by the APP_THEME environment variable.
|
*/

return [
    'light' => [
        'global' => [
            'bgColor' => 'bg-gray-50',
            'formBgColor' => 'bg-white',
            'actionBgColor' => 'bg-white',
            'actionTitleTextColor' => 'text-gray-900',
            'sectionTitleTextColor' => 'text-gray-900',
            'profileBgColor' => 'bg-slate-50',
            'pageBlogBgColor' => 'bg-white',
            'pageBlogTextColor' => 'text-gray-700',
            'pageBlogTitleColor' => 'text-gray-700',
            'pageBorder' => 'border-b border-gray-200',
            'textColor' => 'text-gray-800',
            'accentColor' => 'text-lime-600',
            'profileButtonClass' => 'text-gray-500 hover:text-gray-700 focus:outline-none focus:bg-gray-50 active:bg-gray-50',
            'profileTeamButtonClass' => 'text-gray-500 hover:text-gray-700 focus:outline-none focus:bg-gray-50 active:bg-gray-50',
            'dropDownClass' => 'bg-white',
            'dropDownLinkClass' => 'text-gray-700 hover:bg-gray-100 focus:bg-gray-100',
            'spinnerColor' => '#48c10b',
            'spinnerTextColor' => 'text-gray-700',
        ],
        'header' => [
            'bgColor' => 'bg-gray-50',
            'menuLinkClass' => 'mx-2 text-gray-600 hover:text-gray-800',
            'subHeaderClass' => 'font-semibold text-xl text-gray-800 leading-tight',
            'responsiveNavClass' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-transparent text-start text-base font-medium text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 focus:outline-none focus:text-gray-800 focus:bg-gray-50 focus:border-gray-300 transition duration-150 ease-in-out',
            'responsiveNavClassActive' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-indigo-400 text-start text-base font-medium text-indigo-700 bg-indigo-50 focus:outline-none focus:text-indigo-800 focus:bg-indigo-100 focus:border-indigo-700 transition duration-150 ease-in-out',
            'navClass' => 'inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:outline-none focus:text-gray-700 focus:border-gray-300 transition duration-150 ease-in-out',
            'navClassActive' => 'inline-flex items-center px-1 pt-1 border-b-2 border-indigo-400 text-sm font-medium leading-5 text-gray-900 focus:outline-none focus:border-indigo-700 transition duration-150 ease-in-out',
        ],
        'heroSection' => [
            'bgColor' => 'bg-gray-50',
            'titleColor' => 'text-gray-800',
            'subtitleColor' => 'text-gray-600',
            'ctaBackgroundColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBackgroundColor' => 'hover:bg-lime-700',
        ],
        'interactiveFeaturesSection' => [
            'bgColor' => 'bg-gray-50',
            'titleColor' => 'text-gray-800',
            'descriptionColor' => 'text-gray-600',
            'tabTextColor' => 'text-gray-600',
            'activeTabIconColor' => 'text-lime-600',
            'tabIconColor' => 'text-gray-600',
            'checkmarkColor' => 'text-lime-600',
        ],
        'ctaSection' => [
            'bgColor' => 'bg-gray-50',
            'titleColor' => 'text-gray-800',
            'descriptionColor' => 'text-gray-600',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'customModal' => [
            'bgColor' => 'bg-white',
            'textColor' => 'text-gray-900',
            'overlayColor' => 'bg-gray-500',
            'overlayOpacity' => 'bg-opacity-75',
            'footerBgColor' => 'bg-gray-100',
            'confirmBtnBgColor' => 'bg-blue-600',
            'confirmBtnHoverBgColor' => 'hover:bg-blue-700',
            'confirmBtnTextColor' => 'text-white',
            'cancelBtnBgColor' => 'bg-white',
            'cancelBtnHoverBgColor' => 'hover:bg-gray-50',
            'cancelBtnTextColor' => 'text-gray-700',
            'cancelBtnBorderColor' => 'border-gray-300',
        ],
        'faqItem' => [
            'questionClass' => 'text-lg font-semibold text-gray-800',
            'answerClass' => 'text-gray-700 mt-2',
            'borderClass' => 'border-b border-gray-200',
        ],
        'faqSection' => [
            'bgColor' => 'bg-gray-50',
            'textColor' => 'text-gray-800',
            'titleColor' => 'text-black',
        ],
        'featureItem' => [
            'bgColor' => 'bg-white',
            'iconColor' => 'text-lime-600',
            'titleColor' => 'text-gray-900',
            'contentColor' => 'text-gray-600',
        ],
        'featureSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-gray-800',
            'descriptionColor' => 'text-gray-600',
            'listItemColor' => 'text-gray-600',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'featuresGrid' => [
            'bgColor' => 'bg-gray-50',
            'titleColor' => 'text-gray-800',
        ],
        'pricingPlan' => [
            'bgColor' => 'bg-white',
            'highlightBorderColor' => 'border-lime-500',
            'highlightBadgeColor' => 'bg-lime-600',
            'highlightBadgeTextColor' => 'text-white',
            'nameColor' => 'text-gray-800',
            'priceColor' => 'text-gray-900',
            'featureColor' => 'text-gray-600',
            'ctaBtnBgColor' => 'bg-lime-600',
            'ctaBtnTextColor' => 'text-white',
            'ctaBtnHoverBgColor' => 'hover:bg-lime-700',
            'ctaSmTextColor' => 'text-gray-600',
            'spinnerColor' => 'text-white',
        ],
        'pricingSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-gray-800',
        ],
        'toggleButton' => [
            'class' => 'bg-lime-600 hover:bg-lime-700',
        ],
        'testimonialSection' => [
            'bgColor' => 'bg-gray-50',
            'cardBgColor' => 'bg-white',
            'titleColor' => 'text-gray-900',
            'quoteColor' => 'text-gray-700',
            'authorNameColor' => 'text-gray-900',
            'authorTitleColor' => 'text-gray-600',
        ],
        'verticalFeatureSection' => [
            'bgColor' => 'bg-gray-50',
            'titleColor' => 'text-gray-800',
            'descriptionColor' => 'text-gray-600',
            'listItemColor' => 'text-gray-600',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'footer' => [
            'footerClass' => 'bg-gray-900 text-white py-12',
        ],
    ],
    'dark' => [
        'global' => [
            'bgColor' => 'bg-gray-900',
            'formBgColor' => 'bg-gray-300',
            'actionBgColor' => 'bg-gray-300',
            'actionTitleTextColor' => 'text-white',
            'sectionTitleTextColor' => 'text-white',
            'profileBgColor' => 'bg-gray-700',
            'pageBlogBgColor' => 'bg-gray-800',
            'pageBlogTextColor' => 'text-gray-300',
            'pageBlogTitleColor' => 'text-gray-100',
            'pageBorder' => '',
            'textColor' => 'text-gray-100',
            'accentColor' => 'text-lime-500',
            'profileButtonClass' => 'text-gray-400 hover:text-gray-200 focus:outline-none focus:bg-gray-800 active:bg-gray-800',
            'profileTeamButtonClass' => 'text-gray-400 hover:text-gray-200 focus:outline-none focus:bg-gray-800 active:bg-gray-800',
            'dropDownClass' => 'bg-gray-800',
            'dropDownLinkClass' => 'text-gray-300 hover:bg-gray-700 focus:bg-gray-700',
            'spinnerColor' => '#48c10b',
            'spinnerTextColor' => 'text-white',
        ],
        'header' => [
            'bgColor' => 'bg-gray-900',
            'menuLinkClass' => 'mx-2 text-gray-400 hover:text-gray-200',
            'subHeaderClass' => 'font-semibold text-xl text-gray-100 leading-tight',
            'responsiveNavClass' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-transparent text-start text-base font-medium text-gray-400 hover:text-gray-200 hover:bg-gray-800 hover:border-gray-600 focus:outline-none focus:text-gray-200 focus:bg-gray-800 focus:border-gray-600 transition duration-150 ease-in-out',
            'responsiveNavClassActive' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-indigo-500 text-start text-base font-medium text-indigo-300 bg-gray-800 focus:outline-none focus:text-indigo-200 focus:bg-gray-700 focus:border-indigo-400 transition duration-150 ease-in-out',
            'navClass' => 'inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-400 hover:text-gray-200 hover:border-gray-700 focus:outline-none focus:text-gray-200 focus:border-gray-700 transition duration-150 ease-in-out',
            'navClassActive' => 'inline-flex items-center px-1 pt-1 border-b-2 border-lime-500 text-sm font-medium leading-5 text-gray-100 focus:outline-none focus:border-lime-600 transition duration-150 ease-in-out',
        ],
        'heroSection' => [
            'bgColor' => 'bg-gray-900',
            'titleColor' => 'text-gray-100',
            'subtitleColor' => 'text-gray-400',
            'ctaBackgroundColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBackgroundColor' => 'hover:bg-lime-700',
        ],
        'interactiveFeaturesSection' => [
            'bgColor' => 'bg-gray-900',
            'titleColor' => 'text-gray-100',
            'descriptionColor' => 'text-gray-400',
            'tabTextColor' => 'text-gray-400',
            'activeTabIconColor' => 'text-lime-500',
            'tabIconColor' => 'text-gray-400',
            'checkmarkColor' => 'text-lime-500',
        ],
        'ctaSection' => [
            'bgColor' => 'bg-gray-900',
            'titleColor' => 'text-gray-100',
            'descriptionColor' => 'text-gray-400',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'customModal' => [
            'bgColor' => 'bg-gray-800',
            'textColor' => 'text-gray-100',
            'overlayColor' => 'bg-black',
            'overlayOpacity' => 'bg-opacity-75',
            'footerBgColor' => 'bg-gray-900',
            'confirmBtnBgColor' => 'bg-blue-600',
            'confirmBtnHoverBgColor' => 'hover:bg-blue-700',
            'confirmBtnTextColor' => 'text-white',
            'cancelBtnBgColor' => 'bg-gray-700',
            'cancelBtnHoverBgColor' => 'hover:bg-gray-600',
            'cancelBtnTextColor' => 'text-gray-300',
            'cancelBtnBorderColor' => 'border-gray-600',
        ],
        'faqItem' => [
            'questionClass' => 'text-lg font-semibold text-gray-100',
            'answerClass' => 'text-gray-300 mt-2',
            'borderClass' => 'border-b border-gray-700',
        ],
        'faqSection' => [
            'bgColor' => 'bg-gray-900',
            'textColor' => 'text-gray-100',
            'titleColor' => 'text-gray-100',
            'titleColor' => 'text-white',
        ],
        'featureItem' => [
            'bgColor' => 'bg-gray-800',
            'iconColor' => 'text-lime-500',
            'titleColor' => 'text-gray-100',
            'contentColor' => 'text-gray-400',
        ],
        'featureSection' => [
            'bgColor' => 'bg-gray-800',
            'titleColor' => 'text-gray-100',
            'descriptionColor' => 'text-gray-400',
            'listItemColor' => 'text-gray-400',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'featuresGrid' => [
            'bgColor' => 'bg-gray-900',
            'titleColor' => 'text-gray-100',
        ],
        'pricingPlan' => [
            'bgColor' => 'bg-gray-800',
            'highlightBorderColor' => 'border-lime-500',
            'highlightBadgeColor' => 'bg-lime-600',
            'highlightBadgeTextColor' => 'text-white',
            'nameColor' => 'text-gray-100',
            'priceColor' => 'text-gray-100',
            'featureColor' => 'text-gray-400',
            'ctaBtnBgColor' => 'bg-lime-600',
            'ctaBtnTextColor' => 'text-white',
            'ctaBtnHoverBgColor' => 'hover:bg-lime-700',
            'ctaSmTextColor' => 'text-gray-400',
            'spinnerColor' => 'text-white',
        ],
        'pricingSection' => [
            'bgColor' => 'bg-gray-800',
            'titleColor' => 'text-gray-100',
        ],
        'toggleButton' => [
            'class' => 'bg-lime-600 hover:bg-lime-700',
        ],
        'testimonialSection' => [
            'bgColor' => 'bg-gray-900',
            'cardBgColor' => 'bg-gray-800',
            'titleColor' => 'text-gray-100',
            'quoteColor' => 'text-gray-300',
            'authorNameColor' => 'text-gray-100',
            'authorTitleColor' => 'text-gray-400',
        ],
        'verticalFeatureSection' => [
            'bgColor' => 'bg-gray-900',
            'titleColor' => 'text-gray-100',
            'descriptionColor' => 'text-gray-400',
            'listItemColor' => 'text-gray-400',
            'ctaBgColor' => 'bg-lime-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-lime-700',
        ],
        'footer' => [
            'footerClass' => 'bg-gray-900 text-gray-300 py-12',
        ],
    ],
    'nature' => [
        'global' => [
            'bgColor' => 'bg-emerald-50',
            'formBgColor' => 'bg-white',
            'actionBgColor' => 'bg-white',
            'actionTitleTextColor' => 'text-emerald-800',
            'sectionTitleTextColor' => 'text-emerald-800',
            'profileBgColor' => 'bg-white',
            'pageBlogBgColor' => 'bg-white',
            'pageBlogTextColor' => 'text-emerald-700',
            'pageBlogTitleColor' => 'text-emerald-900',
            'pageBorder' => 'border-emerald-200',
            'textColor' => 'text-emerald-800',
            'accentColor' => 'text-amber-600',
            'profileButtonClass' => 'text-emerald-600 hover:text-emerald-800 focus:outline-none focus:bg-emerald-100',
            'profileTeamButtonClass' => 'text-emerald-600 hover:text-emerald-800 focus:outline-none focus:bg-emerald-100',
            'dropDownClass' => 'bg-white',
            'dropDownLinkClass' => 'text-emerald-700 hover:bg-emerald-50',
            'spinnerColor' => '#059669',
            'spinnerTextColor' => 'text-emerald-800',
        ],
        'header' => [
            'bgColor' => 'bg-emerald-50',
            'menuLinkClass' => 'mx-2 text-emerald-600 hover:text-emerald-800',
            'subHeaderClass' => 'font-semibold text-xl text-emerald-800 leading-tight',
            'responsiveNavClass' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-emerald-200 text-emerald-600 hover:text-emerald-800 hover:bg-emerald-100',
            'responsiveNavClassActive' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-amber-500 text-emerald-800 bg-emerald-100',
            'navClass' => 'inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-emerald-600 hover:text-emerald-800 hover:border-emerald-300 focus:outline-none focus:text-emerald-800 focus:border-emerald-300 transition duration-150 ease-in-out',
            'navClassActive' => 'inline-flex items-center px-1 pt-1 border-b-2 border-amber-500 text-sm font-medium leading-5 text-emerald-900 focus:outline-none focus:border-amber-600 transition duration-150 ease-in-out',
        ],
        'heroSection' => [
            'bgColor' => 'bg-emerald-50',
            'titleColor' => 'text-emerald-900',
            'subtitleColor' => 'text-emerald-700',
            'ctaBackgroundColor' => 'bg-amber-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBackgroundColor' => 'hover:bg-amber-700',
        ],
        'interactiveFeaturesSection' => [
            'bgColor' => 'bg-emerald-50',
            'titleColor' => 'text-emerald-900',
            'descriptionColor' => 'text-emerald-700',
            'tabTextColor' => 'text-emerald-700',
            'activeTabIconColor' => 'text-amber-600',
            'tabIconColor' => 'text-emerald-600',
            'checkmarkColor' => 'text-amber-600',
        ],
        'ctaSection' => [
            'bgColor' => 'bg-emerald-50',
            'titleColor' => 'text-emerald-900',
            'descriptionColor' => 'text-emerald-700',
            'ctaBgColor' => 'bg-amber-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-amber-700',
        ],
        'customModal' => [
            'bgColor' => 'bg-white',
            'textColor' => 'text-emerald-800',
            'overlayColor' => 'bg-emerald-900',
            'overlayOpacity' => 'bg-opacity-75',
            'footerBgColor' => 'bg-emerald-50',
            'confirmBtnBgColor' => 'bg-amber-600',
            'confirmBtnHoverBgColor' => 'hover:bg-amber-700',
            'confirmBtnTextColor' => 'text-white',
            'cancelBtnBgColor' => 'bg-emerald-100',
            'cancelBtnHoverBgColor' => 'hover:bg-emerald-200',
            'cancelBtnTextColor' => 'text-emerald-700',
            'cancelBtnBorderColor' => 'border-emerald-200',
        ],
        'faqItem' => [
            'questionClass' => 'text-lg font-semibold text-emerald-900',
            'answerClass' => 'text-emerald-700 mt-2',
            'borderClass' => 'border-b border-emerald-200',
        ],
        'faqSection' => [
            'bgColor' => 'bg-emerald-50',
            'textColor' => 'text-emerald-800',
            'titleColor' => 'text-emerald-900',
        ],
        'featureItem' => [
            'bgColor' => 'bg-white',
            'iconColor' => 'text-amber-600',
            'titleColor' => 'text-emerald-900',
            'contentColor' => 'text-emerald-700',
        ],
        'featureSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-emerald-900',
            'descriptionColor' => 'text-emerald-700',
            'listItemColor' => 'text-emerald-700',
            'ctaBgColor' => 'bg-amber-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-amber-700',
        ],
        'featuresGrid' => [
            'bgColor' => 'bg-emerald-50',
            'titleColor' => 'text-emerald-900',
        ],
        'pricingPlan' => [
            'bgColor' => 'bg-white',
            'highlightBorderColor' => 'border-amber-500',
            'highlightBadgeColor' => 'bg-amber-600',
            'highlightBadgeTextColor' => 'text-white',
            'nameColor' => 'text-emerald-900',
            'priceColor' => 'text-emerald-900',
            'featureColor' => 'text-emerald-700',
            'ctaBtnBgColor' => 'bg-amber-600',
            'ctaBtnTextColor' => 'text-white',
            'ctaBtnHoverBgColor' => 'hover:bg-amber-700',
            'ctaSmTextColor' => 'text-emerald-700',
            'spinnerColor' => 'text-white',
        ],
        'pricingSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-emerald-900',
        ],
        'toggleButton' => [
            'class' => 'bg-amber-600 hover:bg-amber-700',
        ],
        'testimonialSection' => [
            'bgColor' => 'bg-emerald-50',
            'cardBgColor' => 'bg-white',
            'titleColor' => 'text-emerald-900',
            'quoteColor' => 'text-emerald-700',
            'authorNameColor' => 'text-emerald-900',
            'authorTitleColor' => 'text-emerald-600',
        ],
        'verticalFeatureSection' => [
            'bgColor' => 'bg-emerald-50',
            'titleColor' => 'text-emerald-900',
            'descriptionColor' => 'text-emerald-700',
            'listItemColor' => 'text-emerald-700',
            'ctaBgColor' => 'bg-amber-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-amber-700',
        ],
        'footer' => [
            'footerClass' => 'bg-emerald-50 text-emerald-700 py-12',
        ],
    ],
    'sunset' => [
        'global' => [
            'bgColor' => 'bg-orange-50',
            'formBgColor' => 'bg-white',
            'actionBgColor' => 'bg-white',
            'actionTitleTextColor' => 'text-orange-900',
            'sectionTitleTextColor' => 'text-orange-900',
            'profileBgColor' => 'bg-white',
            'pageBlogBgColor' => 'bg-white',
            'pageBlogTextColor' => 'text-orange-800',
            'pageBlogTitleColor' => 'text-orange-900',
            'pageBorder' => 'border-orange-200',
            'textColor' => 'text-orange-800',
            'accentColor' => 'text-rose-600',
            'profileButtonClass' => 'text-orange-700 hover:text-orange-900 focus:outline-none focus:bg-orange-100',
            'profileTeamButtonClass' => 'text-orange-700 hover:text-orange-900 focus:outline-none focus:bg-orange-100',
            'dropDownClass' => 'bg-white',
            'dropDownLinkClass' => 'text-orange-700 hover:bg-orange-50',
            'spinnerColor' => '#ea580c',
            'spinnerTextColor' => 'text-orange-800',
        ],
        'header' => [
            'bgColor' => 'bg-gradient-to-r from-orange-100 to-rose-100',
            'menuLinkClass' => 'mx-2 text-orange-700 hover:text-orange-900',
            'subHeaderClass' => 'font-semibold text-xl text-orange-900 leading-tight',
            'responsiveNavClass' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-orange-200 text-orange-700 hover:text-orange-900 hover:bg-orange-100',
            'responsiveNavClassActive' => 'block w-full ps-3 pe-4 py-2 border-l-4 border-rose-500 text-orange-900 bg-orange-100',
            'navClass' => 'inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-orange-700 hover:text-orange-900 hover:border-orange-300 focus:outline-none focus:text-orange-900 focus:border-orange-300 transition duration-150 ease-in-out',
            'navClassActive' => 'inline-flex items-center px-1 pt-1 border-b-2 border-rose-500 text-sm font-medium leading-5 text-orange-900 focus:outline-none focus:border-rose-600 transition duration-150 ease-in-out',
        ],
        'heroSection' => [
            'bgColor' => 'bg-gradient-to-r from-orange-50 to-rose-50',
            'titleColor' => 'text-orange-900',
            'subtitleColor' => 'text-orange-700',
            'ctaBackgroundColor' => 'bg-rose-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBackgroundColor' => 'hover:bg-rose-700',
        ],
        'interactiveFeaturesSection' => [
            'bgColor' => 'bg-orange-50',
            'titleColor' => 'text-orange-900',
            'descriptionColor' => 'text-orange-700',
            'tabTextColor' => 'text-orange-700',
            'activeTabIconColor' => 'text-rose-600',
            'tabIconColor' => 'text-orange-600',
            'checkmarkColor' => 'text-rose-600',
        ],
        'ctaSection' => [
            'bgColor' => 'bg-orange-50',
            'titleColor' => 'text-orange-900',
            'descriptionColor' => 'text-orange-700',
            'ctaBgColor' => 'bg-rose-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-rose-700',
        ],
        'customModal' => [
            'bgColor' => 'bg-white',
            'textColor' => 'text-orange-800',
            'overlayColor' => 'bg-orange-900',
            'overlayOpacity' => 'bg-opacity-75',
            'footerBgColor' => 'bg-orange-50',
            'confirmBtnBgColor' => 'bg-rose-600',
            'confirmBtnHoverBgColor' => 'hover:bg-rose-700',
            'confirmBtnTextColor' => 'text-white',
            'cancelBtnBgColor' => 'bg-orange-100',
            'cancelBtnHoverBgColor' => 'hover:bg-orange-200',
            'cancelBtnTextColor' => 'text-orange-700',
            'cancelBtnBorderColor' => 'border-orange-200',
        ],
        'faqItem' => [
            'questionClass' => 'text-lg font-semibold text-orange-900',
            'answerClass' => 'text-orange-700 mt-2',
            'borderClass' => 'border-b border-orange-200',
        ],
        'faqSection' => [
            'bgColor' => 'bg-orange-50',
            'textColor' => 'text-orange-800',
            'titleColor' => 'text-orange-900',
        ],
        'featureItem' => [
            'bgColor' => 'bg-white',
            'iconColor' => 'text-rose-600',
            'titleColor' => 'text-orange-900',
            'contentColor' => 'text-orange-700',
        ],
        'featureSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-orange-900',
            'descriptionColor' => 'text-orange-700',
            'listItemColor' => 'text-orange-700',
            'ctaBgColor' => 'bg-rose-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-rose-700',
        ],
        'featuresGrid' => [
            'bgColor' => 'bg-orange-50',
            'titleColor' => 'text-orange-900',
        ],
        'pricingPlan' => [
            'bgColor' => 'bg-white',
            'highlightBorderColor' => 'border-rose-500',
            'highlightBadgeColor' => 'bg-rose-600',
            'highlightBadgeTextColor' => 'text-white',
            'nameColor' => 'text-orange-900',
            'priceColor' => 'text-orange-900',
            'featureColor' => 'text-orange-700',
            'ctaBtnBgColor' => 'bg-rose-600',
            'ctaBtnTextColor' => 'text-white',
            'ctaBtnHoverBgColor' => 'hover:bg-rose-700',
            'ctaSmTextColor' => 'text-orange-700',
            'spinnerColor' => 'text-white',
        ],
        'pricingSection' => [
            'bgColor' => 'bg-white',
            'titleColor' => 'text-orange-900',
        ],
        'toggleButton' => [
            'class' => 'bg-rose-600 hover:bg-rose-700',
        ],
        'testimonialSection' => [
            'bgColor' => 'bg-orange-50',
            'cardBgColor' => 'bg-white',
            'titleColor' => 'text-orange-900',
            'quoteColor' => 'text-orange-700',
            'authorNameColor' => 'text-orange-900',
            'authorTitleColor' => 'text-orange-600',
        ],
        'verticalFeatureSection' => [
            'bgColor' => 'bg-orange-50',
            'titleColor' => 'text-orange-900',
            'descriptionColor' => 'text-orange-700',
            'listItemColor' => 'text-orange-700',
            'ctaBgColor' => 'bg-rose-600',
            'ctaTextColor' => 'text-white',
            'ctaHoverBgColor' => 'hover:bg-rose-700',
        ],
        'footer' => [
            'footerClass' => 'bg-orange-50 text-orange-700 py-12',
        ],
    ],
];
