<?php

namespace App\Livewire\Page\Dashboard;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Locked;
use Livewire\Attributes\On;
use Livewire\Attributes\Renderless;
use Livewire\Component;

class ManageSubscription extends Component
{
    public $subTier;
    public $subStatus;
    public $subEndsAt;
    #[Locked]
    public $plans;
    public User $user;
    #[Locked]
    public $billingProvider;

    #[On('cancelPlan')]
    #[Renderless]
    public function cancelPlan()
    {
        if ($this->billingProvider === 'stripe') {
            Auth::user()->subscription()->cancel();
        }
        $this->dispatch('refreshThePage');
    }

    #[On('restorePlan')]
    #[Renderless]
    public function restorePlan()
    {
        $subscription = Auth::user()->subscription();
        if ($this->billingProvider === 'stripe') {
            $subscription->resume();
        }
        $this->dispatch('refreshThePage');
    }

    public function render()
    {
        return view('livewire.pages.dashboard.manage-subscription');
    }
}
